//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.split;

public class PSSpecial {

    // Our postscript header is borrowed from xdvi, which is available
    // at ftp://ftp.tex.ac.uk/tex-archive/dviware/xdvi/.  It is a copy
    // of the string constant from psheader.c, which is generated from  
    // a postscript file psheader.txt, which in turn is borrowed from  
    // the dvips package availablt at ftp://ftp.tex.ac.uk/tex-archive/dviware/dvips. 
    //
    // Parts of this string are subject to the following:
    //
    //    "All software, documentation, and related files in this distribution of
    //     psfig/tex are Copyright (c) 1987 Trevor J. Darrell
    //
    //     Permission is granted for use and non-profit distribution of psfig/tex
    //     providing that this notice be clearly maintained, but the right to
    //     distribute any portion of psfig/tex for profit or as part of any commercial
    //     product is specifically reserved for the author."
    //
    // Note that the java compiler converts this into a single string constant:

    // Current usage is to compile this class, run it as an application, and put
    // the output into the file psheader.ps in the IDVILIB directory in the installation.

    final static String psSpecialHeader = 
        "/TeXDict 250 dict def TeXDict begin /N{def}def /B{bind def}N /S{exch}N\n"   +
        "/X{S N}B /TR{translate}N end TeXDict begin /SDict 200 dict N SDict begin\n" +
        "/@SpecialDefaults{/hs 612 N /vs 792 N /ho 0 N /vo 0 N /hsc 1 N /vsc 1 N\n"  +
        "/ang 0 N /CLIP 0 N /rwiSeen false N /rhiSeen false N /letter{}N /note{}\n"  +
        "N /a4{}N /legal{}N}B /@scaleunit 100 N /@hscale{@scaleunit div /hsc X}B\n"  +
        "/@vscale{@scaleunit div /vsc X}B /@hsize{/hs X /CLIP 1 N}B /@vsize{/vs X\n" +
        "/CLIP 1 N}B /@clip{/CLIP 2 N}B /@hoffset{/ho X}B /@voffset{/vo X}B\n"       +
        "/@angle{/ang X}B /@rwi{10 div /rwi X /rwiSeen true N}B /@rhi{10 div /rhi\n" +
        "X /rhiSeen true N}B /@llx{/llx X}B /@lly{/lly X}B /@urx{/urx X}B /@ury{\n"  +
        "/ury X}B /magscale true def end /@MacSetUp{userdict /md known{userdict\n"   +
        "/md get type /dicttype eq{userdict begin md length 10 add md maxlength\n"   +
        "ge{/md md dup length 20 add dict copy def}if end md begin /letter{}N\n"     +
        "/note{}N /legal{}N /od{txpose 1 0 mtx defaultmatrix dtransform S atan/pa\n" +
        "X newpath clippath mark{transform{itransform moveto}}{transform{\n"         +
        "itransform lineto}}{6 -2 roll transform 6 -2 roll transform 6 -2 roll\n"    +
        "transform{itransform 6 2 roll itransform 6 2 roll itransform 6 2 roll\n"    +
        "curveto}}{{closepath}}pathforall newpath counttomark array astore /gc\n"    +
        "xdf pop ct 39 0 put 10 fz 0 fs 2 F/|______Courier fnt invertflag{\n"        +
        "PaintBlack}if}N /txpose{pxs pys scale ppr aload pop por{noflips{pop S\n"    +
        "neg S TR pop 1 -1 scale}if xflip yflip and{pop S neg S TR 180 rotate 1\n"   +
        "-1 scale ppr 3 get ppr 1 get neg sub neg ppr 2 get ppr 0 get neg sub neg\n" +
        "TR}if xflip yflip not and{pop S neg S TR pop 180 rotate ppr 3 get ppr 1\n"  +
        "get neg sub neg 0 TR}if yflip xflip not and{ppr 1 get neg ppr 0 get neg\n"  +
        "TR}if}{noflips{TR pop pop 270 rotate 1 -1 scale}if xflip yflip and{TR\n"    +
        "pop pop 90 rotate 1 -1 scale ppr 3 get ppr 1 get neg sub neg ppr 2 get\n"   +
        "ppr 0 get neg sub neg TR}if xflip yflip not and{TR pop pop 90 rotate ppr\n" +
        "3 get ppr 1 get neg sub neg 0 TR}if yflip xflip not and{TR pop pop 270\n"   +
        "rotate ppr 2 get ppr 0 get neg sub neg 0 S TR}if}ifelse scaleby96{ppr\n"    +
        "aload pop 4 -1 roll add 2 div 3 1 roll add 2 div 2 copy TR .96 dup scale\n" +
        "neg S neg S TR}if}N /cp{pop pop showpage pm restore}N end}if}if}N\n"        +
        "/normalscale{Resolution 72 div VResolution 72 div neg scale magscale{\n"    +
        "DVImag dup scale}if 0 setgray}N /psfts{S 65781.76 div N}N /startTexFig{\n"  +
        "/psf$SavedState save N userdict maxlength dict begin /magscale true def\n"  +
        "normalscale currentpoint TR /psf$ury psfts /psf$urx psfts /psf$lly psfts\n" +
        "/psf$llx psfts /psf$y psfts /psf$x psfts /psf$sx psf$x psf$urx psf$llx\n"   +
        "sub div N /psf$sy psf$y psf$ury psf$lly sub div N psf$sx psf$sy scale\n"    +
        "psf$llx neg psf$ury neg TR /showpage{}N /erasepage{}N /copypage{}N /p 3\n"  +
        "def @MacSetUp}N /doclip{psf$llx psf$lly psf$urx psf$ury currentpoint 6 2\n" +
        "roll newpath 4 copy 4 2 roll moveto 6 -1 roll S lineto S lineto S lineto\n" +
        "closepath clip newpath moveto}N /endTexFig{end psf$SavedState restore}N\n"  +
        "/@beginspecial{SDict begin /SpecialSave save N gsave normalscale\n"         +
        "currentpoint TR @SpecialDefaults count /ocount X /dcount countdictstack\n"  +
        "N}N /@setspecial{CLIP 1 eq{newpath 0 0 moveto hs 0 rlineto 0 vs rlineto\n"  +
        "hs neg 0 rlineto closepath clip}if ho vo TR hsc vsc scale ang rotate\n"     +
        "rwiSeen{rwi urx llx sub div rhiSeen{rhi ury lly sub div}{dup}ifelse\n"      +
        "scale llx neg lly neg TR}{rhiSeen{rhi ury lly sub div dup scale llx neg\n"  +
        "lly neg TR}if}ifelse CLIP 2 eq{newpath llx lly moveto urx lly lineto urx\n" +
        "ury lineto llx ury lineto closepath clip}if /showpage{}N /erasepage{}N\n"   +
        "/copypage{}N newpath}N /@endspecial{count ocount sub{pop}repeat\n"          +
        "countdictstack dcount sub{end}repeat grestore SpecialSave restore end}N\n"  +
        "/@defspecial{SDict begin}N /@fedspecial{end}B end\n";
    
    public static void main( String[ ] args ) {
        System.out.print( psSpecialHeader );
    }
}
