//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

import java.awt.Event;

import ibook.v11.idvi.IDVIContext;
import ibook.v11.idvi.ShowDocumentContext;

public class ZoomPanel extends ViewPanel {
    int         xCenter;
    int         yCenter;

    public ZoomPanel(
            Block               block,
            BlockRoot           root,
            ColorScheme         colorScheme,
            int                 scale,
            int                 xCenter,
            int                 yCenter,
            IDVIContext         idviContext,
            ShowDocumentContext showDocumentContext ) {
        
        super( block, root, colorScheme, scale, 0, 0, idviContext, showDocumentContext, false );

        this.xCenter = xCenter;
        this.yCenter = yCenter;

        invalidate( );
    }

    public boolean handleEvent( Event e ) {
        boolean used = super.handleEvent( e );

        if( ! used ) {
            switch( e.id ) {
                case Event.MOUSE_DOWN:
                    used = true;
                    mouseDown( e.x, e.y );
                    break;
                case Event.MOUSE_DRAG:
                    used = true;
                    mouseDrag( e.x, e.y );
                    break;
                case Event.MOUSE_UP:
                    used = true;
                    mouseUp( e.x, e.y );
                    break;
                default:
                    break;
            }
        }

        return used;
    }

    private int     startX;
    private int     startY;

    private int     startXCenter;
    private int     startYCenter;

    private boolean dragging = false;

    private void mouseDown( int x, int y ) {
        startX = x;
        startY = y;

        startXCenter = xCenter;
        startYCenter = yCenter;

        dragging = true;
    }

    private void mouseDrag( int x, int y ) {
        if( dragging )
            setCenter( startXCenter - x + startX, startYCenter - y + startY );
    }

    private void mouseUp( int x, int y ) {
        dragging = false;
    }

    public void setCenter( int xCenter, int yCenter ) {
        this.xCenter = xCenter;
        this.yCenter = yCenter;

        validate( );
    }

    public void validate( ) {
        int width = size( ).width;
        int height = size( ).height;

        setOffsets( - xCenter + width / 2, - yCenter + height / 2 );
    }
}
