//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

final public class DVIRectangle implements Cloneable {
    final static public DVIRectangle    unsetRectangle = new DVIRectangle( );

    public int      top;
    public int      left;
    public int      bottom;
    public int      right;

    public boolean  unset;


    public DVIRectangle( ) {
        unset = true;
    }

    public DVIRectangle( DVIRectangle rectangle ) {
        unset = rectangle.unset;

        if( ! unset ) {
            top    = rectangle.top;
            left   = rectangle.left;
            bottom = rectangle.bottom;
            right  = rectangle.right;
        }
    }

    public DVIRectangle( int top, int left, int bottom, int right ) {
        unset = false;

        this.top    = top;
        this.left   = left;
        this.bottom = bottom;
        this.right  = right;
    }

    public DVIRectangle( java.awt.Rectangle rectangle ) {
        unset = false;

        top    = rectangle.y;
        left   = rectangle.x;
        bottom = top  + rectangle.height;
        right  = left + rectangle.width;
    }

    public DVIRectangle set( ) {
        unset = true;

        return this;
    }

    public DVIRectangle set( DVIRectangle rectangle ) {
        unset = rectangle.unset;

        if( ! unset ) {
            top    = rectangle.top;
            left   = rectangle.left;
            bottom = rectangle.bottom;
            right  = rectangle.right;
        }

        return this;
    }

    public DVIRectangle set( int top, int left, int bottom, int right ) {
        unset = false;

        this.top    = top;
        this.left   = left;
        this.bottom = bottom;
        this.right  = right;

        return this;
    }

    public DVIRectangle set( java.awt.Rectangle rectangle ) {
        unset = false;

        top    = rectangle.y;
        left   = rectangle.x;
        bottom = top  + rectangle.height;
        right  = left + rectangle.width;

        return this;
    }

    public DVIRectangle setTop( int top ) {
        this.top = top;

        return this;
    }

    public DVIRectangle setLeft( int left ) {
        this.left = left;

        return this;
    }

    public DVIRectangle setBottom( int bottom ) {
        this.bottom = bottom;

        return this;
    }

    public DVIRectangle setRight( int right ) {
        this.right = right;

        return this;
    }

    public DVIRectangle setX( int x ) {
        this.right -= this.left - x;
        this.left = x;

        return this;
    }

    public DVIRectangle setY( int y ) {
        this.bottom -= this.top - y;
        this.top = y;

        return this;
    }

    public DVIRectangle setWidth( int width ) {
        this.right = this.left + width;

        return this;
    }

    public DVIRectangle setHeight( int height ) {
        this.bottom = this.top + height;

        return this;
    }

    public DVIRectangle offsetTop( int top ) {
        this.top += top;

        return this;
    }

    public DVIRectangle offsetLeft( int left ) {
        this.left += left;

        return this;
    }

    public DVIRectangle offsetBottom( int bottom ) {
        this.bottom += bottom;

        return this;
    }

    public DVIRectangle offsetRight( int right ) {
        this.right += right;

        return this;
    }

    public DVIRectangle offsetX( int xOffset ) {
        this.left += xOffset;
        this.right += xOffset;

        return this;
    }

    public DVIRectangle offsetY( int yOffset ) {
        this.top += yOffset;
        this.bottom += yOffset;

        return this;
    }

    public DVIRectangle union( DVIRectangle rectangle ) {
        if( ! rectangle.unset )
            if( unset ) {
                unset = false;

                top    = rectangle.top;
                left   = rectangle.left;
                bottom = rectangle.bottom;
                right  = rectangle.right;
            } else {
                if( rectangle.top    < top    ) top    = rectangle.top;
                if( rectangle.left   < left   ) left   = rectangle.left;
                if( rectangle.bottom > bottom ) bottom = rectangle.bottom;
                if( rectangle.right  > right  ) right  = rectangle.right;
            }
        
        return this;
    }

    public DVIRectangle union( int top, int left, int bottom, int right ) {
        if( unset ) {
            unset = false;

            this.top    = top;
            this.left   = left;
            this.bottom = bottom;
            this.right  = right;
        } else {
            if( top    < this.top    ) this.top    = top;
            if( left   < this.left   ) this.left   = left;
            if( bottom > this.bottom ) this.bottom = bottom;
            if( right  > this.right  ) this.right  = right;
        }

        return this;
    }

    public DVIRectangle intersect( DVIRectangle rectangle ) {
        if( ! unset && ! rectangle.unset ) {
            if( rectangle.top    > top    ) top    = rectangle.top;
            if( rectangle.left   > left   ) left   = rectangle.left;
            if( rectangle.bottom < bottom ) bottom = rectangle.bottom;
            if( rectangle.right  < right  ) right  = rectangle.right;
        } else
            unset = true;
        
        return this;
    }

    public DVIRectangle intersect( int top, int left, int bottom, int right ) {
        if( ! unset ) {
            if( top    > this.top    ) this.top    = top;
            if( left   > this.left   ) this.left   = left;
            if( bottom < this.bottom ) this.bottom = bottom;
            if( right  < this.right  ) this.right  = right;
        }

        return this;
    }

    public boolean intersects( DVIRectangle rectangle ) {
        return ! unset && ! rectangle.unset &&
            rectangle.top    < bottom &&
            rectangle.left   < right  &&
            rectangle.bottom > top    &&
            rectangle.right  > left;
    }

    public boolean intersects( int top, int left, int bottom, int right ) {
        return ! unset &&
            top    < this.bottom &&
            left   < this.right  &&
            bottom > this.top    &&
            right  > this.left;
    }

    public Object clone( ) {
        try {
            return super.clone( );
        } catch( CloneNotSupportedException e ) {
            return new DVIRectangle( this );
        }
    }

    public java.awt.Rectangle toRectangle( ) {
        return new java.awt.Rectangle( left, top, right - left, bottom - top );
    }

    public String toString( ) {
        return new String( unset ? "unset" : top + "," + left + "," + bottom + "," + right );
    }
}
