//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.net.URL;

import ibook.v11.idvi.AppletContainer;
import ibook.v11.parameter.ParameterStub;
import ibook.v11.parameter.ParameterUnionStub;

class AppletView extends ComponentView implements AppletStub, AppletContainer {
    private Applet              applet;
    private ViewPanel           panel;
    private AppletContext       context;
    private ParameterUnionStub  parameter;
    private boolean             started = false;
    private boolean             showing = false;
    private boolean             reallyStarted = false;
    private int                 appletWidth;
    private int                 appletHeight;




    AppletView( Applet applet, ParameterStub appletParameter, int width, int height, int expansion, ViewPanel panel ) {
        super( applet, width, height, expansion, panel );

        this.applet = applet;
        this.panel = panel;
        this.context = panel.getAppletContext( );

        this.appletWidth = width;
        this.appletHeight = height;

        parameter = new ParameterUnionStub( );
        parameter.add( appletParameter );
        parameter.add( panel.getParameterProcessor( ).getStub( ));

        if( applet != null ) {
            applet.setStub( this );
            panel.registerAppletContainer( this );
        }
    }

    void showComponents( int componentXOffset, int componentYOffset ) {
        if( ! showing ) {
            showing = true;
            doStartStop( );
        }
        super.showComponents( componentXOffset, componentYOffset );
    }

    void hideComponents( ) {
        super.hideComponents( );

        if( showing ) {
            showing = false;
            doStartStop( );
        }
    }




    //  AppletContainer implementation:

    public void init( ) {
        if( applet != null ) {
            applet.init( );
            applet.resize( appletWidth, appletHeight );
            applet.validate( );
        }
    }

    public void start( ) {
        started = true;
        doStartStop( );
    }

    public void stop( ) {
        started = false;
        doStartStop( );
    }

    public void destroy( ) {
        if( applet != null ) {
            panel.remove( applet );
            applet.destroy( );
            applet = null;
        }
    }




    //  AppletStub implementation:

    public boolean isActive( ) {
        return reallyStarted;
    }

    public URL getDocumentBase( ) {
        return panel.getDVIDocumentBase( );
    }

    public URL getCodeBase( ) {
        return panel.getCodeBase( );
    }

    //  Parameters come from our ParameterStub.  We don't just
    //  use a hashtable, because we want to make the parameters
    //  of our containing applet available as well.

    public String getParameter( String name ) {
        return parameter.getParameter( name.toLowerCase( ));
    }

    //  We just return the context which we obtain from our ViewPanel,
    //  which is in turn the context of our containing applet.

    public AppletContext getAppletContext( ) {
        return context;
    }

    //  appletResize( ) would be difficult to implement in the View heierarchy,
    //  because our width might change.

    public void appletResize( int width, int height ) {
    }




    private void doStartStop( ) {
        boolean newStarted = started && showing;

        if( applet != null )
            if( newStarted && ! reallyStarted ) {
                applet.start( );
            } else if( ! newStarted && reallyStarted )
                applet.stop( );

        reallyStarted = newStarted;
    }
}
