//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

class ActionBlockGroup {
    final private static int    kActionBlockInitialLength = 1;

    private int                 actionBlockCount = 0;
    private ActionBlock[ ]      actionBlock;
    private String              href;
    private String              target;

    ActionBlockGroup( String href, String target ) {
        this.href = href;
        this.target = target;
    }

    //  The addActionBlock( ) and doneAddingActionBlocks( ) methods are to be
    //  called by the parser while constructing a Block tree.

    void addActionBlock( ActionBlock actionBlock ) {
        if( this.actionBlock == null )
            this.actionBlock = new ActionBlock[ kActionBlockInitialLength ];
        else if( this.actionBlock.length == actionBlockCount )
            setActionBlockLength( 2 * this.actionBlock.length );
        
        this.actionBlock[ actionBlockCount ++ ] = actionBlock;
    }

    void doneAddingActionBlocks( ) {
        if( actionBlock != null && actionBlock.length > actionBlockCount )
            setActionBlockLength( actionBlockCount );
    }

    //  The setSelected( ) method is called by an ActionView method which
    //  is tracking the mouse, and should notify all ActionViews associated
    //  with this ActionBlockGroup of the new state.  It does this by
    //  notifying the ActionBlocks, which in turn notify the ActionViews.

    private boolean selected = false;

    void setSelected( boolean selected ) {
        this.selected = selected;

        for( int i = 0; i < actionBlockCount; ++ i )
            actionBlock[ i ].setSelected( selected );
    }

    boolean getSelected( ) {
        return selected;
    }

    String getHREF( ) {
        return href;
    }

    String getTarget( ) {
        return target;
    }




    private void setActionBlockLength( int length ) {
        ActionBlock[ ] oldActionBlock = actionBlock;
        actionBlock = new ActionBlock[ length ];
        System.arraycopy( oldActionBlock, 0, actionBlock, 0, Math.min( oldActionBlock.length, length ));
    }
}
