//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.colors;

//  CreateColorDocumentation is a Java application which prints the Color values
//  from the Colors class in html format.

public class CreateColorDocumentation {
    public static void main( String[ ] args ) {
        int count = Colors.name.length;

        for( int i = 0; i < count; ++ i ) {
            if( i % 2 == 0 )
                System.out.println( );
            else
                System.out.print( ",            " );

            String name = Colors.name[ i ];
            String value = Integer.toString( Colors.color[ i ], 16 ).toUpperCase( );

            if( value.length( ) < 6 )
                value = "000000".substring( value.length( )) + value;

            System.out.print( "<font color=\"#" + value + "\">" + name + "</font>" );
        }
        System.out.println( );
    }
}
