//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.applets.hithere;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class HiThereApplet extends Applet {
    String message = "Hi There!";

    public void init( ) {
        System.out.println( "HiThereApplet: init" );
    }

    public void start( ) {
        System.out.println( "HiThereApplet: start" );
    }

    public void stop( ) {
        System.out.println( "HiThereApplet: stop" );
    }

    public void destroy( ) {
        System.out.println( "HiThereApplet: destroy" );
    }

    public void paint( Graphics g ) {
        Dimension size = size( );
        FontMetrics metrics = getFontMetrics( getFont( ));

        int descent = metrics.getDescent( );
        int height = metrics.getAscent( ) + descent;
        int width = metrics.stringWidth( message );

        int x = ( size.width - width ) / 2;
        int y = ( size.height + height ) / 2 - descent;

        g.drawString( message, x, y );

        g.setColor( Color.red );
        g.drawRect( 0, 0, size.width - 1, size.height - 1 );
    }

    final private static String[ ] clickString = { "Single Click", "Double Click", "Triple Click", "Hey!  Stop That!" };

    public boolean mouseDown( Event event, int x, int y ) {
        int clickCount = Math.min( event.clickCount, clickString.length );

        message = clickString[ clickCount - 1 ];
        repaint( );

        return false;
    }

    public boolean keyDown( Event event, int key ) {
        message = "Key Code " + key;
        repaint( );

        return false;
    }
}
