//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.util;

//  A call to SharedCondition.put( ) allows all presently waiting
//  and all subsequent calls to SharedCondition.get( ) to succeed.
//  The method SharedCondition.clear( ) is used to reset the condition.
//
//  Examples of constuction:
//      new SharedCondition( ); // waiting, by default
//      new SharedCondition( Condition.ready );
//      new SharedCondition( Condition.waiting );

public class SharedCondition extends Condition {
    private boolean state;

    public SharedCondition( boolean state ) {
        this.state = state;
    }

    public SharedCondition( ) {
        this( waiting );
    }

    public synchronized void clear( ) {
        state = waiting;
    }

    public synchronized void get( ) {
        while( state == waiting )
            try {
                wait( );
            } catch( InterruptedException e ) {
            }
    }

    public synchronized void put( ) {
        state = ready;
        notifyAll( );
    }
}
