//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.util;

//  A call to ExclusiveCondition.put( ) allows exactly one call to
//  ExclusiveCondition.get( ) to return.
//
//  Examples of constuction:
//      new ExclusiveCondition( ); // waiting, by default
//      new ExclusiveCondition( Condition.ready );
//      new ExclusiveCondition( Condition.waiting );

public class ExclusiveCondition extends Condition {
    private boolean state;

    public ExclusiveCondition( boolean state ) {
        this.state = state;
    }

    public ExclusiveCondition( ) {
        this( waiting );
    }

    public synchronized void clear( ) {
        state = waiting;
    }

    public synchronized void get( ) {
        while( state == waiting )
            try {
                wait( );
            } catch( InterruptedException e ) {
            }

        state = waiting;
    }

    public synchronized void put( ) {
        state = ready;
        notify( );
    }
}
