//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.io;

import java.io.*;

public final class DVIOutputStream {
    public OutputStream dest;
    public int          offset = 0;

    public DVIOutputStream( OutputStream dest ) {
        this.dest = dest;
    }

    public final void close( ) throws IOException {
        dest.close( );
    }

    public final int getOffset( ) {
        return offset;
    }

    public final void write( int source ) throws IOException {
        dest.write( source );
        offset ++;
    }

    public final void write1( int source ) throws IOException {
        dest.write( source );
        offset ++;
    }

    public final void write2( int source) throws IOException {
        dest.write(( source >> 8 ) & 0xFF );
        dest.write(( source >> 0 ) & 0xFF );
        offset += 2;
    }

    public final void write3( int source ) throws IOException {
        dest.write(( source >> 16 ) & 0xFF );
        dest.write(( source >> 8 ) & 0xFF );
        dest.write(( source >> 0 ) & 0xFF );
        offset += 3;
    }

    public final void write4( int source ) throws IOException {
        dest.write(( source >> 24 ) & 0xFF );
        dest.write(( source >> 16 ) & 0xFF );
        dest.write(( source >> 8 ) & 0xFF );
        dest.write(( source >> 0 ) & 0xFF );
        offset += 4;
    }

    public final void write( byte[ ] source ) throws IOException {
        dest.write( source );
        offset += source.length;
    }

    public final void write( byte[ ] source, int offset, int length ) throws IOException {
        dest.write( source, offset, length );
        offset += length;
    }

    public final void write( String source ) throws IOException {
        byte[ ] buffer = new byte[ source.length( ) ];
        source.getBytes( 0, source.length( ), buffer, 0 );
        dest.write( buffer );
        offset += buffer.length;
    }

    public final void writeVariableSized( int commandBase, int value ) throws IOException {
        if( value <= 0xFF ) {
            dest.write( commandBase );
            dest.write( value );
            offset += 2;
        } else if( value < 0xFFFF ) {
            dest.write( commandBase + 1 );
            dest.write(( value >> 8 ) & 0xFF );
            dest.write(( value >> 0 ) & 0xFF );
            offset += 3;
        } else if( value < 0xFFFFFF ) {
            dest.write( commandBase + 2 );
            dest.write(( value >> 16 ) & 0xFF );
            dest.write(( value >> 8 ) & 0xFF );
            dest.write(( value >> 0 ) & 0xFF );
            offset += 4;
        } else {
            dest.write( commandBase + 3 );
            dest.write(( value >> 24 ) & 0xFF );
            dest.write(( value >> 16 ) & 0xFF );
            dest.write(( value >> 8 ) & 0xFF );
            dest.write(( value >> 0 ) & 0xFF );
            offset += 5;
        }
    }

    public final void write( DVIInputStream source, int length ) throws IOException {
        for( int i = 0; i < length; ++ i )
            dest.write( source.read( ));

        offset += length;
    }
}
