//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Graphics;

class ViewPanelView extends View {
    private ViewPanel   panel;

    ViewPanelView( ViewPanel panel ) {
        this.panel = panel;
    }

    void childAddedToBounds( DVIRectangle newBounds, int expansion ) {
        panel.viewAddedToBounds( newBounds, expansion );
    }

    void childAddedToFlags( int newFlags ) {
        panel.viewAddedToFlags( newFlags );
    }

    void childChangedExpansion( int childIndex, int expansionDelta, int yPosition ) {
        panel.viewChangedExpansion( expansionDelta, yPosition );
    }

    void childBounds( DVIRectangle childBounds, int childIndex ) {
        panel.childBounds( childBounds );
    }

    void repaint( DVIRectangle repaintBounds, int childIndex, long delay ) {
        panel.repaint( repaintBounds, delay );
    }
}
