//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Graphics;

class ToggleView extends FilterView {
    boolean         visible;

    boolean         unset = true;
    int             lastBottom;
    int             top;
    int             bottom;
    int             toggleTop;
    int             invisibleExpansion = 0;
    int             childExpansion = 0;

    boolean         childHasComponents;
    int             componentXOffset;
    int             componentYOffset;




    //  Out constructor and setVisible( ) are called only by our Block:

    ToggleView( ScaledColorScheme colorScheme, int scale, ViewPanel panel, Block childBlock, boolean visible ) {
        super( colorScheme, scale, panel, childBlock );

        this.visible = visible;
    }

    void setVisible( boolean visible ) {
        if( visible != this.visible && ! unset ) {
            this.visible = visible;

            int delta = invisibleExpansion - childExpansion;
            super.childChangedExpansion( 0, visible ? - delta : delta, toggleTop );

            if( childHasComponents ) {
                if( visible )
                    super.showComponents( componentXOffset, componentYOffset );
                else
                    super.hideComponents( );
            }
        }
    }




    //

    int getFlags( ) {
        int result = super.getFlags( );
        childHasComponents = ( result & kFlagHasComponents ) != 0;

        return result;
    }

    int getBounds( DVIRectangle bounds, int scale, int x, int y, Block block ) {
        childExpansion = super.getBounds( bounds, scale, x, y, childBlock );

        unset = bounds.unset;
        lastBottom = super.getBottomOfPreviousChild( 0 );

        if( ! unset ) {
            top = bounds.top;
            bottom = bounds.bottom;
            toggleTop = lastBottom == Integer.MAX_VALUE ? top : lastBottom;
            invisibleExpansion = toggleTop - bottom;
        }

        return visible ? childExpansion : invisibleExpansion;
    }

    void showComponents( int componentXOffset, int componentYOffset ) {
        this.componentXOffset = componentXOffset;
        this.componentYOffset = componentYOffset;

        if( visible )
            super.showComponents( componentXOffset, componentYOffset );
    }

    void hideComponents( ) {
        if( visible )
            super.hideComponents( );
    }

    void paint( Graphics g, int color, DVIRectangle bounds, DVIRectangle clip, int yOffset ) {
        if( visible )
            super.paint( g, color, bounds, clip, yOffset );
    }




    //  childAddedToBounds( ), childChangedExpansion( ), and repaint( ) are called by our child.

    void childAddedToBounds( DVIRectangle newBounds, int expansion ) {
        if( ! newBounds.unset ) {
            super.childAddedToBounds( newBounds, visible ? childExpansion : invisibleExpansion );

            int oldExpansion = invisibleExpansion;

            unset = false;
            top = newBounds.top;
            bottom = newBounds.bottom;
            toggleTop = lastBottom == Integer.MAX_VALUE ? top : lastBottom;
            invisibleExpansion = toggleTop - bottom;

            if( ! visible && oldExpansion != invisibleExpansion )
                super.childChangedExpansion( 0, invisibleExpansion - oldExpansion, toggleTop );
        }
    }

    void childAddedToFlags( int newFlags ) {
        childHasComponents |= ( newFlags & kFlagHasComponents ) != 0;
            
        super.childAddedToFlags( newFlags );
    }

    void childChangedExpansion( int childIndex, int delta, int yPosition ) {
        childExpansion += delta;

        if( visible )
            super.childChangedExpansion( childIndex, delta, yPosition );
    }

    void repaint( DVIRectangle repaintBounds, int childIndex, long delay ) {
        if( visible )
            super.repaint( repaintBounds, childIndex, delay );
    }




    public String toString( ) {
        return super.toString( ) + ", visible = " + visible;
    }
}
