//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

class ToggleBlock extends Block {
    final private static int    kViewInitialLength = 2;
    final private static int    kViewIncrementLength = 2;

    private int                 viewCount;
    private ToggleView[ ]       view;
    private Block               child;

    private boolean             visible;

    ToggleBlock( boolean visible ) {
        this.visible = visible;
    }

    void setChild( Block child ) {
        this.child = child;
    }

    //  getView should not be called on a ToggleBlock until after
    //  the setChild( ) method has been called with a non-null child.

    View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        ToggleView result = new ToggleView( colorScheme, scale, panel, child, visible );

        addView( result );

        return result;
    }

    void toggle( ) {
        setVisible( ! visible );
    }

    void setVisible( boolean visible ) {
        if( this.visible != visible ) {
            this.visible = visible;

            for( int i = 0; i < viewCount; ++ i )
                view[ i ].setVisible( visible );
        }
    }




    private synchronized void addView( ToggleView newView ) {
        if( view == null )
            view = new ToggleView[ kViewInitialLength ];
        else if( viewCount == view.length )
            setViewLength( view.length + kViewIncrementLength );

        view[ viewCount ++ ] = newView;
    }

    private void setViewLength( int length ) {
        View[ ] oldView = view;
        view = new ToggleView[ length ];
        System.arraycopy( oldView, 0, view, 0, Math.min( oldView.length, length ));
    }
}
