//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Graphics;

class LinkActionView extends ActionView {
    final private static int    kUnderlineThickness = 1;
    final private static int    kUnderlineOffset = 2;

    LinkActionView(
            ScaledColorScheme colorScheme, int scale, ViewPanel panel,
            ActionBlockGroup group, Block blockChild, boolean selected, boolean childDoneLoading ) {
        
        super( colorScheme, scale, panel,
                group, blockChild,
                ScaledColorScheme.kIndexLink, ScaledColorScheme.kIndexLink, ScaledColorScheme.kIndexSelectedLink,
                selected, childDoneLoading );
    }

    void paintAdornment( Graphics g, int color, DVIRectangle bounds, DVIRectangle clip ) {
        if( clip.bottom > bounds.bottom - kUnderlineThickness )
            g.fillRect(
                bounds.left,
                bounds.bottom - kUnderlineThickness,
                bounds.right - bounds.left,
                kUnderlineThickness );
    }

    void addAdornmentBounds( DVIRectangle bounds ) {
        bounds.bottom += kUnderlineOffset;
    }

    void removeAdornmentBounds( DVIRectangle bounds ) {
        bounds.bottom -= kUnderlineOffset;
    }

    void getAdornmentBounds( DVIRectangle adornmentBounds ) {
        adornmentBounds.top = adornmentBounds.bottom - kUnderlineThickness;
    }
}
