//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Hashtable;

class ImageView extends View implements ImageObserver {
    private Image       image;
    private String      imageName;
    private int         width;
    private int         height;
    private ViewPanel   panel;
    private boolean     error = false;

    ImageView( Image image, String imageName, int width, int height, ViewPanel panel ) {
        this.image = image;
        this.imageName = imageName;
        this.width = width;
        this.height = height;
        this.panel = panel;
    }

    private View        parent;
    private int         indexInParent;

    void setParent( View parent, int indexInParent ) {
        this.parent = parent;
        this.indexInParent = indexInParent;
    }

    private int         top;
    private int         left;

    int getBounds( DVIRectangle bounds, int scale, int x, int y, Block block ) {
        int bottom = y / scale;
        top  = bottom - height;
        left = x / scale;

        bounds.set( top, left, bottom, left + width );

        return 0;
    }

    void paint( Graphics g, int color, DVIRectangle bounds, DVIRectangle clip, int yOffset ) {
        if( image != null && ! error )
            g.drawImage( image, bounds.left, bounds.top, this );
    }

    private DVIRectangle repaintScratch = new DVIRectangle( );

    public boolean imageUpdate( Image image, int infoflags, int x, int y, int width, int height ) {
        if(( infoflags & SOMEBITS ) != 0 ) {
            BlockLock lock = panel.getLock( );
            
            lock.getReader( );

            repaintScratch.set( top + y, left + x, top + y + height, left + x + width );
            parent.repaint( repaintScratch, indexInParent, kRepaintDelayProgressive );

            lock.putReader( );
        }

        if(( infoflags & ERROR ) != 0 && ! error ) {
            error = true;
            System.out.println( "Error while loading image \"" + imageName + "\"" );
        }

        return ( infoflags & ( ALLBITS | ABORT )) == 0;
    }
}
