//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

import ibook.v10.idvi.IDVI;
import ibook.v10.idvi.IDVIContext;

//  There is at most one ImageBlock for each name; the name includes scaling information.
//  There is at most one Image for each image URL. Unfortunately, we need one ImageView
//  for each occurence in the page, because of (the poor design of) ImageObservers.

class ImageBlock extends Block {
    //  Externally visible method for obtaining new ImageBlock objects.

    final private static int    kCacheInitialSize = 13;

    private static Hashtable    cache = new Hashtable( kCacheInitialSize );

    static synchronized ImageBlock getImageBlock( String name, int width, int height ) {
        ImageBlock result = ( ImageBlock ) cache.get( name );

        if( result == null ) {
            result = new ImageBlock( name, width, height );
            cache.put( name, result );
        }

        return result;
    }

    //  Internal method for obtaining the corresponding Image objects.

    final private static int    kImageCacheInitialSize = 13;

    private static Hashtable    imageCache = new Hashtable( kImageCacheInitialSize );

    private static Image getImage( String fullName, IDVIContext context ) {
        Image result = null;
        
        try {
            URL url = new URL( context.getDVIDocumentBase( ), fullName );
            result = ( Image ) imageCache.get( url );

            if( result == null ) {
                result = context.getAppletContext( ).getImage( url );
                imageCache.put( url, result );
            }
        } catch( MalformedURLException e ) {
        }

        return result;
    }

    private String      name;
    private int         width;
    private int         height;

    private ImageBlock( String name, int width, int height ) {
        this.name = name;
        this.width = width;
        this.height = height;
    }

    private ViewPanel   lastPanel = null;
    private int         lastScale = -1;
    private String      lastPrefix;
    private String      lastFullName;
    private Image       lastImage;

    synchronized View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        if( panel != lastPanel || scale != lastScale ) {
            if( panel != lastPanel ) {
                lastPanel = panel;
                lastPrefix = panel.getParameterProcessor( ).getString( "scalePrefix", IDVI.kDefaultScalePrefix );
            }
            
            lastFullName = name + lastPrefix + scale + ".gif";
            lastImage = getImage( lastFullName, panel );
        }

        return new ImageView( lastImage, lastFullName, ( width + scale - 1 ) / scale, ( height + scale - 1 ) / scale, panel );
    }
}
