//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.ColorModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

import ibook.v10.idvi.AppletContainer;
import ibook.v10.idvi.IDVIContext;
import ibook.v10.idvi.MessageContext;
import ibook.v10.idvi.ShowDocumentContext;
import ibook.v10.idvi.font.DVICharacter;
import ibook.v10.idvi.font.DVIFont;
import ibook.v10.parameter.*;
import ibook.v10.util.ExclusiveCondition;

public class ContainerTestApplet extends ParameterApplet implements Runnable, IDVIContext, MessageContext, ShowDocumentContext {
    int                 background   = 0xFFFFFF;
    int                 foreground   = 0x000000;
    int                 selection    = 0xC0FFFF;
    int                 link         = 0x0000EE;
    int                 selectedLink = 0xFF0000;

    int                 background2   = 0x000000;
    int                 foreground2   = 0x00FF20;
    int                 selection2    = 0xC0FFFF;
    int                 link2         = 0x0000EE;
    int                 selectedLink2 = 0xFF0000;

    ExclusiveCondition  condition = new ExclusiveCondition( );

    Block               characterBlock;
    Block               ruleBlock;
    Block               imageBlock;
    Block               componentBlock;
    ContainerBlock      containerBlock = new ContainerBlock( );
    ActionBlockGroup    group = new ActionBlockGroup( "idvi:toggle:#1", "" );
    BlockRoot           root = new BlockRoot( );

    BlockLock           blockLock;
    ViewPanel           panel;

    public void init( ) {
        super.init( );

        try {
            String fontName  = parameter.getString ( "font"     , "cmr10" );
            URL    fontBase  = parameter.getURL    ( "fontbase" , "file:/usr/tex/fonts/pk/" );
            int    size      = parameter.getInteger( "size"     , 300 );
            int    scale     = parameter.getInteger( "scale"    , 3 );
            int    character = parameter.getInteger( "character", 60 );

            DVIFont font = DVIFont.getFontNoSearch( fontBase, fontName, size, this );
            DVICharacter dviCharacter = font.getCharacter( character );

            characterBlock = CharacterBlock.getCharacterBlock( dviCharacter );
            ruleBlock = RuleBlock.getRuleBlock( 182, 7 );
            imageBlock = ImageBlock.getImageBlock( "eidmagroot/fewer", 582, 179 );
    //      componentBlock = new ButtonBlock( "Hello", 100, 25 );

            Hashtable appletParameterHashtable = new Hashtable( 5 );
            appletParameterHashtable.put( "height", "25" );
            ParameterStub appletParameterStub = new HashtableParameterStub( appletParameterHashtable );
            componentBlock = new AppletBlock( "ibook.release.HiThereApplet", 300, 500, appletParameterStub );

            ColorScheme colorScheme1 =
                    ColorScheme.getColorScheme( background, foreground, selection, link, selectedLink );
            ColorScheme colorScheme2 =
                    ColorScheme.getColorScheme( background2, foreground2, selection2, link2, selectedLink2 );
                
            root.setBlock( containerBlock );
            blockLock = root.getBlockLock( );

            ViewPanel panel1 = new ViewPanel( containerBlock, root, colorScheme1, scale,  86,  58, this, this, true );
            ViewPanel panel2 = new ZoomPanel( containerBlock, root, colorScheme2, 1    , 140, 200, this, this );

            setBackground( Color.white );
            setLayout( new BorderLayout( ));
            Panel row = new Panel( );
            row.setLayout( new GridLayout( 1, 2 ));
            add( "Center", row );

            row.add( panel1 );
            row.add( panel2 );

            panel = panel2;

        } catch( ParameterException e ) {
            e.printStackTrace( );
        }
    }

    private boolean started = false;

    public void start( ) {
        if( ! started ) {
            started = true;
            new Thread( this ).start( );
        }
    }

    public boolean keyDown( Event event, int key ) {
        if( key == ' ' )
            panel.printStructure( );
        else    
            condition.put( );

        return true;
    }

    public void run( ) {
        ContainerBlock top = new ContainerBlock( );
        ContainerBlock middle = new ContainerBlock( );
        ContainerBlock bottom = new ContainerBlock( );
        ContainerBlock linkContents = new ContainerBlock( );
        ActionBlock action1 = new LinkActionBlock( group );
        ActionBlock action2 = new ToggleActionBlock( group );
        ToggleBlock toggle = new ToggleBlock( false );
        toggle.setChild( middle );
        root.putNamedBlock( "idvi:toggle:#1", toggle );
        action1.setChild( linkContents );
        action2.setChild( ruleBlock );
        action2.childDoneLoading( );

        condition.get( );

        blockLock.getAddToBlockLock( );
        containerBlock.addChild( top, 0, 0 );
        containerBlock.flushChildren( );
        top.addChild( characterBlock, 50, 50 );
        top.addChild( action1, 0, 0 );
        top.flushChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        linkContents.addChild( characterBlock, 100, 50 );
        linkContents.addChild( characterBlock, 150, 50 );
        linkContents.flushChildren( );
        linkContents.doneAddingChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        action1.childDoneLoading( );
        top.addChild( characterBlock, 200, 50 );
        top.flushChildren( );
        top.doneAddingChildren( );
        containerBlock.addChild( toggle, 0, 0 );
        containerBlock.flushChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        middle.addChild( ruleBlock, 50, 80 );
        middle.addChild( action2, 50, 94 );
        middle.addChild( ruleBlock, 50, 108 );
        middle.flushChildren( );
        middle.doneAddingChildren( );
        containerBlock.addChild( bottom, 0, 0 );
        containerBlock.flushChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        bottom.addChild( characterBlock, 50, 158 );
        bottom.addChild( characterBlock, 100, 158 );
        bottom.addChild( characterBlock, 150, 158 );
        bottom.addChild( characterBlock, 200, 158 );
        bottom.flushChildren( );
        bottom.doneAddingChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        containerBlock.addChild( imageBlock, -143, 360 );
        containerBlock.flushChildren( );
        blockLock.putAddToBlockLock( );
        condition.get( );

        blockLock.getAddToBlockLock( );
        containerBlock.addChild( componentBlock, 140, 600 );
        containerBlock.flushChildren( );
        containerBlock.doneAddingChildren( );
        blockLock.putAddToBlockLock( );
    }

    //  MessageContext implementation:

    public void showMessage( String message ) {
        showStatus( message );
    }

    //  IDVIContext implementation:

    public void showDocument( String urlString, String target ) {
        System.out.println( "showDocument, urlString = \"" + urlString + "\", target = \"" + target + "\"" );
    }

    public ParameterProcessor getParameterProcessor( ) {
        return parameter;
    }

    public URL getDVIDocumentBase( ) {
        return getDocumentBase( );
    }

    public void registerAppletContainer( AppletContainer container ) {
    }
}
