//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.awt.Component;

//  ComponentView is a little bit strange.  It takes a width and height in
//  pixels, and will center its component, with that width and height, over
//  the x, y coordinates it is given by its parent.

class ComponentView extends View {
    private Component   component;
    private int         scaledX;
    private int         scaledY;
    private int         width;
    private int         height;
    private int         expansion;

    ComponentView( Component component, int width, int height, int expansion, ViewPanel panel ) {
        this.component = component;
        this.width = width;
        this.height = height;
        this.expansion = expansion;

        if( component != null ) {
            component.hide( );
            panel.add( component );
        }
    }

    int getFlags( ) {
        return component != null ? kFlagHasComponents : 0;
    }

    //  Note: the component is effectively centered at position (x,y).  The left
    //  and sides of the bounds rectangle are those of the component itself.  The
    //  top and bottom sides are from the object that this component is hiding, and
    //  the expansion makes the bounds just the right size for the height of the
    //  component.

    int getBounds( DVIRectangle bounds, int scale, int x, int y, Block block ) {
        scaledX = ( x + scale - 1 ) / scale - width / 2;
        scaledY = ( y + scale - 1 ) / scale + expansion / 2 - height / 2;

        bounds.set( scaledY, scaledX, scaledY + height - expansion, scaledX + width );
        return expansion;
    }

    void showComponents( int componentXOffset, int componentYOffset ) {
        if( component != null ) {
            component.reshape( scaledX + componentXOffset, scaledY + componentYOffset, width, height );
            component.show( );
        }
    }

    void hideComponents( ) {
        if( component != null )
            component.hide( );
    }

    public String toString( ) {
        return super.toString( ) + ", component = " + component;
    }
}
