//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.Image;

public class ColorTestApplet extends Applet {
    int     background   = 0xFFFFFF;
    int     foreground   = 0x000000;
    int     selection    = 0xC0FFFF;
    int     link         = 0x0000EE;
    int     selectedLink = 0xFF0000;

    int     width = 600;
    int     height = 200;
    int     scale = 3;

    ScaledColorScheme   scaledScheme;

    public void init( ) {
        ColorScheme scheme = ColorScheme.getColorScheme( background, foreground, selection, link, selectedLink );
        ColorScheme scheme2 = ColorScheme.getColorScheme( background, foreground, selection, link, selectedLink );
        ColorScheme scheme3 = ColorScheme.getColorScheme( foreground, background, selection, link, selectedLink );

        System.out.println( "scheme and scheme2 should be the same, and are" + ( scheme == scheme2 ? "." : " not!" ));
        System.out.println( "scheme and scheme3 should be different, and are" + ( scheme != scheme3 ? "." : " not!" ));

        scaledScheme = scheme.getScaledColorScheme( scale );
        ScaledColorScheme scaledScheme2 = scheme.getScaledColorScheme( scale );
        ScaledColorScheme scaledScheme3 = scheme.getScaledColorScheme( scale + 1 );

        System.out.println( "scaled and scaled2 should be the same, and are" + ( scaledScheme == scaledScheme2 ? "." : " not!" ));
        System.out.println( "scaled and scaled3 should be different, and are" + ( scaledScheme != scaledScheme3 ? "." : " not!" ));
    }

    public void paint( Graphics g ) {
        int     xCount = scale * scale + 1;

        int     eachHeight = height / ScaledColorScheme.kIndexCount;
        int     eachWidth = width / xCount;

        int     yInset = eachHeight / 4;
        int     xInset = eachWidth / 4;

        for( int index = 0; index < ScaledColorScheme.kIndexCount; ++ index ) {
            int y = index * eachHeight;

            fillRect( g, 0, y, width, eachHeight, scaledScheme.getBackgroundColor( index ));

            for( int xIndex = 0; xIndex < xCount; ++ xIndex ) {
                int x = xIndex * eachWidth;

                fillRect( g, x + xInset, y + yInset, eachWidth - 2 * xInset, eachHeight - 2 * yInset,
                        scaledScheme.getColor( index, xIndex ));
            }
        }
    }

    public void update( Graphics g ) {
        paint( g );
    }

    private void fillRect( Graphics g, int x, int y, int width, int height, Color color ) {
        byte[ ] red   = new byte[ 1 ];
        byte[ ] green = new byte[ 1 ];
        byte[ ] blue  = new byte[ 1 ];

        red  [ 0 ] = ( byte ) color.getRed  ( );
        green[ 0 ] = ( byte ) color.getGreen( );
        blue [ 0 ] = ( byte ) color.getBlue ( );

        byte[ ] bits = new byte[ 1 ];
        bits[ 0 ] = 0;

        Image image = createImage(
            new MemoryImageSource( 1, 1, new IndexColorModel( 8, 1, red, green, blue ), bits, 0, 0 ));
        
        g.drawImage( image, x, y, width, height, null );
    }
}
