//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

class ColorBlock extends Block {
    int         color;
    Block       child;

    ColorBlock( int color ) {
        this.color = color;
    }

    void setChild( Block child ) {
        this.child = child;
    }

    View getView( ScaledColorScheme scaledColorScheme, int scale, ViewPanel panel ) {
        ColorScheme colorScheme = scaledColorScheme.getColorScheme( );
        ColorScheme newColorScheme = ColorScheme.getColorScheme( colorScheme, color );
        ScaledColorScheme newScaledColorScheme = newColorScheme.getScaledColorScheme( scale );

        return child.getView( newScaledColorScheme, scale, panel );
    }
}
