//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.util.Hashtable;

//  BlockRoot keeps a central store of information about a Block hierarchy.
//  This includes:
//
//      block
//          The Block at the root of the hierarchy.  Initialized when a
//          parser calls setBlock( ).  Accessed by a client prior to creating
//          a ViewPanel for the whole hierarchy by calling getBlock( ).
//          
//      lock
//          An BlockLock which is used to synchronize access to the Block
//          hierarchy as well as any View hierarchies which are created from it.
//          Accessed from the ViewPanel constructor by calling getLock( ).
//
//      namedBlocks
//          A table matching names to Blocks contained in the hierarchy.
//          Used by the ViewPanel method processSpecialURL( ) to find which
//          ToggleBlock should be toggled in response to an ActionBlock
//          selection, by calling getNamedBlock( ).  Initialized by the
//          parser, by a sequence of calls to putNamedBlock( ).

public class BlockRoot {
    BlockLock   lock = new BlockLock( );
    Block       block;

    //  getBlockLock( ) is used to obtain the locking object for this
    //  block hierarchy.  It is used by the ViewPanel class.

    BlockLock getBlockLock( ) {
        return lock;
    }

    //  getBlock( ) is called by a client which wishes to create
    //  a view of the whole Block heierarchy.

    public Block getBlock( ) {
        return block;
    }

    void setBlock( Block block ) {
        this.block = block;
    }

    //  addNamedBlock( ) is called by the parser during loading.
    //  Then later, a ViewPanel can call getNamedBlock( ) to
    //  retrieve the block.  This is used for outlining, at the moment.
    //
    //  Potentially, this could be used to retrieve just part of
    //  a page (as tagged by <a name=...> </a>, for example).

    Hashtable   namedBlocks = new Hashtable( 5 );

    void putNamedBlock( String name, Block block ) {
        namedBlocks.put( name, block );
    }

    Block getNamedBlock( String name ) {
        return ( Block ) namedBlocks.get( name );
    }
}
