//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

//  Each Block heierarchy has a single BlockLock object,
//  which is used to control all access to that heierarchy
//  and all associated Views.
//
//  This vastly simplifies synchronization, when compared
//  to trying to lock each Block and View separately as
//  it is read or modified.  It particular, we don't need
//  to worry about the order in which locks are obtained.
//
//  Clients are Parser objects and ViewPanel objects:
//
//  Parser: modifies the Block heierarchy by calling
//  the setChild( ) method of PageBlock and the addChild( ),
//  doneAddingChildren( ), and flushChildren( ) methods of
//  ContainerBlock.  Around each of these operations (or
//  groups of them), the BlockParser should use a
//  getAddToBlockLock( ), putAddToBlockLock( ) pair.
//
//  ViewPanel: reads and slightly modifies (by adding a new
//  View to each Block) the Block heierarchy by calling the
//  getView( ) method, reads the View heierarchy (and possibly
//  some information from the Block heierarchy as well) by
//  calling the paint( ) method, and reads and modifies state
//  information in all Views and the Block heierarchy during
//  the processing of events.  Each of these three operations
//  should be surrounded by the appropriate get*Lock( ),
//  put*Lock( ) pair.
//
//  In the current implementation, the getAddToBlockLock( )
//  and getModifyStateLock( ) methods obtain an exclusive
//  (or write) lock on the whole Block/View structure, while
//  getGetViewLock( ) and getPaintLock( ) obtain a shared
//  (or read) lock.  This requires some extra synchronization
//  in Blocks which maintain a list of Views (ContainerBlock,
//  ActionBlock, DefinitionBlock), but allows construction of
//  new Views, which may be time-consuming, while painting
//  existing Views.

class BlockLock extends ibook.v10.util.ReadWriteLock {
    void getAddToBlockLock( ) {
        getWriter( );
    }
    
    void putAddToBlockLock( ) {
        putWriter( );
    }

    void getGetViewLock( ) {
        getReader( );
    }

    void putGetViewLock( ) {
        putReader( );
    }

    void getPaintLock( ) {
        getReader( );
    }

    void putPaintLock( ) {
        putReader( );
    }

    void getModifyStateLock( ) {
        getWriter( );
    }

    void putModifyStateLock( ) {
        putWriter( );
    }
}
