//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.display;

import java.applet.Applet;

import ibook.v10.parameter.ParameterStub;

class AppletBlock extends Block {
    String          code;
    int             unscaledWidth;
    int             unscaledHeight;
    ParameterStub   parameter;

    Class           appletClass = null;

    boolean         hasFixedWidth = false;
    boolean         hasFixedHeight = false;
    int             fixedWidth;
    int             fixedHeight;

    AppletBlock( String code, int unscaledWidth, int unscaledHeight, ParameterStub parameter ) {
        this.code = code;
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.parameter = parameter;

        try {
            appletClass = Class.forName( code );
        } catch( ClassNotFoundException e ) {
            System.out.println( "Applet \"" + code + "\" not found." );
        }

        String widthString = parameter.getParameter( "width" );
        String heightString = parameter.getParameter( "height" );

        if( widthString != null )
            try {
                fixedWidth = Integer.parseInt( widthString );
                hasFixedWidth = true;
            } catch( NumberFormatException e ) {
            }

        if( heightString != null )
            try {
                fixedHeight = Integer.parseInt( heightString );
                hasFixedHeight = true;
            } catch( NumberFormatException e ) {
            }
    }

    View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        int width = hasFixedWidth ? fixedWidth : ( unscaledWidth + scale - 1 ) / scale;
        int height = hasFixedHeight ? fixedHeight : ( unscaledHeight + scale - 1 ) / scale;
        int expansion = hasFixedHeight ? fixedHeight - ( unscaledHeight + scale - 1 ) / scale : 0;

        Applet applet = null;
        if( panel.getIncludeComponents( ) && appletClass != null )
            try {
                applet = ( Applet ) appletClass.newInstance( );
            } catch( ClassCastException e ) {
                System.out.println( "Exception creating applet \"" + code + "\"." );
                System.out.println( "Make sure that the applet class extends java.applet.Applet." );
            } catch( InstantiationException e ) {
                System.out.println( "Exception creating applet \"" + code + "\"." );
                System.out.println( "Make sure that the applet class is not abstract or an interface." );
            } catch( IllegalAccessException e ) {
                System.out.println( "Exception creating applet \"" + code + "\"." );
                System.out.println( "Make sure that the applet class is public." );
            }

        return new AppletView( applet, parameter, width, height, expansion, panel );
    }
}
