//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.controls;

import java.awt.*;
import java.util.Hashtable;

import ibook.v10.awt.RegularLayout;
import ibook.v10.idvi.ShowDocumentContext;
import ibook.v10.idvi.IDVI;

public class NavigationPanel extends Panel {
    ShowDocumentContext context;

    Component       scaleMoreButton;
    Component       scaleLessButton;

    Component       firstPageButton;
    Component       previousPageButton;
    PageField       pageField;
    Component       nextPageButton;
    Component       lastPageButton;

    Component       helpButton;

    Hashtable       actions = new Hashtable( 10 );

    public NavigationPanel( ShowDocumentContext context ) {
        this.context = context;

        scaleMoreButton    = new NavigationButton( "-", IDVI.kIDVIURLPrefix + IDVI.kScaleOffsetURLPrefix + "1", this );
        scaleLessButton    = new NavigationButton( "+", IDVI.kIDVIURLPrefix + IDVI.kScaleOffsetURLPrefix + "-1", this );

        firstPageButton    = new NavigationButton( "|<-", IDVI.kIDVIURLPrefix + IDVI.kPageMinURL, this );
        previousPageButton = new NavigationButton( "<-", IDVI.kIDVIURLPrefix + IDVI.kPageOffsetURLPrefix + "-1", this );
        pageField          = new PageField( this );
        nextPageButton     = new NavigationButton( "->", IDVI.kIDVIURLPrefix + IDVI.kPageOffsetURLPrefix + "1", this );
        lastPageButton     = new NavigationButton( "->|", IDVI.kIDVIURLPrefix + IDVI.kPageMaxURL, this );

        helpButton         = new NavigationButton( "?", IDVI.kHelpURLString, this );

        RegularLayout layout = new RegularLayout( );

        layout.add( scaleMoreButton,    0, 0, 2, 1 );
        layout.add( scaleLessButton,    2, 0, 2, 1 );
        layout.add( firstPageButton,    5, 0, 2, 1 );
        layout.add( previousPageButton, 7, 0, 2, 1 );
        layout.add( pageField,          9, 0, 3, 1 );
        layout.add( nextPageButton,    12, 0, 2, 1 );
        layout.add( lastPageButton,    14, 0, 2, 1 );
        layout.add( helpButton,        17, 0, 2, 1 );

        layout.setStretchColumn( 16 );

        add( scaleMoreButton    );
        add( scaleLessButton    );
        add( firstPageButton    );
        add( previousPageButton );
        add( pageField          );
        add( nextPageButton     );
        add( lastPageButton     );
        add( helpButton         );

        setLayout( layout );
    }

    public void scaleChanged( int scale, boolean isMin, boolean isMax ) {
        scaleMoreButton.enable( ! isMax );
        scaleLessButton.enable( ! isMin );
    }

    public void pageChanged( int pageNumber, boolean isMin, boolean isMax ) {
        pageField.setValue( pageNumber );

        firstPageButton.enable( ! isMin );
        previousPageButton.enable( ! isMin );
        nextPageButton.enable( ! isMax );
        lastPageButton.enable( ! isMax );
    }

    public void showPage( int pageNumber ) {
        context.showDocument( IDVI.kIDVIURLPrefix + IDVI.kPageURLPrefix + pageNumber, "_self" );
    }

    public void showDocument( String urlString, String target ) {
        context.showDocument( urlString, target );
    }
}

final class PageField extends TextField {
    private NavigationPanel parent;
    private int             value;

    PageField( NavigationPanel parent ) {
        this.parent = parent;
    }

    public boolean action( Event event, Object message ) {
        try {
            int newValue = Integer.parseInt(( String ) message );
            if( newValue != value ) {
                value = newValue;
                parent.showPage( value );
            }
        } catch( NumberFormatException e ) {
            showValue( );
        }

        return true;
    }

    void setValue( int value ) {
        this.value = value;
        showValue( );
    }

    private void showValue( ) {
        setText( Integer.toString( value ));
        selectAll( );
    }
}

final class NavigationButton extends Button {
    private String          urlString;
    private NavigationPanel parent;

    NavigationButton( String label, String urlString, NavigationPanel parent ) {
        super( label );

        this.urlString = urlString;
        this.parent = parent;
    }

    public boolean action( Event event, Object message ) {
        parent.showDocument( urlString, ( event.modifiers & Event.ALT_MASK ) != 0 ? "_blank" : "_self" );

        return true;
    }
}
