//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.idvi.controls;

import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;

class ControlFrame extends Frame {
    private Controls    controls;
    private int         width;
    private int         height;

    ControlFrame( String title, Controls controls, int width, int height ) {
        super( title );

        this.controls = controls;
        this.width = width;
        this.height = height;
    }

    public boolean handleEvent( Event event ) {
        if( event.id == Event.WINDOW_DESTROY ) {
            controls.forceHide( );
            return true;
        } else if( event.id == Event.KEY_PRESS ) {
            return controls.keyDown( event.key );
        } else
            return super.handleEvent( event );
    }

    public Dimension preferredSize( ) {
        Dimension minimum = super.preferredSize( );

        return new Dimension( Math.max( minimum.width, width ), Math.max( minimum.height, height ));
    }
}
