//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.colors;

//  CreateColorTable is a Java application which converts a CMYK color table
//  (with values corresponding to the names in Colors.java) into an RGB color
//  table.  The conversion function in Colors.java is used.

public class CreateColorTable {
    static private double cmyk[ ] = {
        0.15, 0.00, 0.69, 0.00,  0.00, 0.00, 1.00, 0.00,  0.00, 0.10, 0.84, 0.00,  0.00, 0.29, 0.84, 0.00,
        0.00, 0.32, 0.52, 0.00,  0.00, 0.50, 0.70, 0.00,  0.00, 0.46, 0.50, 0.00,  0.00, 0.42, 1.00, 0.00,
        0.00, 0.61, 0.87, 0.00,  0.00, 0.51, 1.00, 0.00,  0.00, 0.75, 1.00, 0.24,  0.00, 0.77, 0.87, 0.00,
        0.00, 0.85, 0.87, 0.35,  0.00, 0.87, 0.68, 0.32,  0.00, 0.89, 0.94, 0.28,  0.00, 1.00, 1.00, 0.00,
        0.00, 1.00, 0.50, 0.00,  0.00, 1.00, 0.13, 0.00,  0.00, 0.96, 0.39, 0.00,  0.00, 0.53, 0.38, 0.00,
        0.00, 0.63, 0.00, 0.00,  0.00, 1.00, 0.00, 0.00,  0.00, 0.81, 0.00, 0.00,  0.00, 0.82, 0.00, 0.00,
        0.34, 0.90, 0.00, 0.02,  0.07, 0.90, 0.00, 0.34,  0.47, 0.91, 0.00, 0.08,  0.00, 0.48, 0.00, 0.00,
        0.12, 0.59, 0.00, 0.00,  0.32, 0.64, 0.00, 0.00,  0.40, 0.80, 0.20, 0.00,  0.45, 0.86, 0.00, 0.00,
        0.50, 1.00, 0.00, 0.00,  0.79, 0.88, 0.00, 0.00,  0.75, 0.90, 0.00, 0.00,  0.86, 0.91, 0.00, 0.04,
        0.57, 0.55, 0.00, 0.00,  0.62, 0.57, 0.23, 0.00,  0.65, 0.13, 0.00, 0.00,  0.98, 0.13, 0.00, 0.43,
        0.94, 0.54, 0.00, 0.00,  1.00, 0.50, 0.00, 0.00,  1.00, 1.00, 0.00, 0.00,  0.94, 0.11, 0.00, 0.00,
        1.00, 0.00, 0.00, 0.00,  0.96, 0.00, 0.00, 0.00,  0.62, 0.00, 0.12, 0.00,  0.85, 0.00, 0.20, 0.00,
        0.86, 0.00, 0.34, 0.02,  0.82, 0.00, 0.30, 0.00,  0.85, 0.00, 0.33, 0.00,  1.00, 0.00, 0.50, 0.00,
        0.99, 0.00, 0.52, 0.00,  0.69, 0.00, 0.50, 0.00,  1.00, 0.00, 1.00, 0.00,  0.91, 0.00, 0.88, 0.12,
        0.92, 0.00, 0.59, 0.25,  0.50, 0.00, 1.00, 0.00,  0.44, 0.00, 0.74, 0.00,  0.26, 0.00, 0.76, 0.00,
        0.64, 0.00, 0.95, 0.40,  0.00, 0.72, 1.00, 0.45,  0.00, 0.83, 1.00, 0.70,  0.00, 0.81, 1.00, 0.60,
        0.14, 0.42, 0.56, 0.00,  0.00, 0.00, 0.00, 0.50,  0.00, 0.00, 0.00, 1.00,  0.00, 0.00, 0.00, 0.00,
    };

    public static void main( String[ ] args ) {
        System.out.print( " static private int color[ ] = {" );

        int count = cmyk.length / 4;
        for( int i = 0; i < count; ++ i ) {
            if( i % 4 == 0 )
                System.out.print( "\n       " );
            else
                System.out.print( ", " );

            int rgb = Colors.getCMYKColor( cmyk[ i * 4 ], cmyk[ i * 4 + 1 ], cmyk[ i * 4 + 2 ], cmyk[ i * 4 + 3 ] );

            String shortString = Integer.toString( rgb, 16 ).toUpperCase( );
            String padding = "000000".substring( shortString.length( ));

            System.out.print( "0x" + padding + shortString );
        }

        System.out.println( "\n };" );
    }
}
