//  IDVI 1.0 source copyright 1996 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.0 source copyright 1996 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v10.awt;

import java.awt.Container;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;

//  FloatCenterLayout centers its one child in the parent
//  Container, giving it its preferred size.
//
//  The optional width and height arguments give the layout
//  its preferred size; otherwise its preferred size is 0x0.

public class FloatCenterLayout implements LayoutManager {
    Component   child;
    int         width;
    int         height;

    public FloatCenterLayout( int width, int height ) {
        this.width = width;
        this.height = height;
    }

    public FloatCenterLayout( ) {
        this( 0, 0 );
    }

    public void addLayoutComponent( String name, Component child ) {
        this.child = child;
    }

    public void removeLayoutComponent( Component child ) {
        if( this.child == child )
            this.child = null;
    }

    public Dimension preferredLayoutSize( Container parent ) {
        return new Dimension( width, height );
    }

    public Dimension minimumLayoutSize( Container parent ) {
        return new Dimension( width, height );
    }

    public void layoutContainer( Container parent ) {
        if( child != null ) {
            Dimension childSize = child.preferredSize( );
            Dimension parentSize = parent.size( );

            child.reshape(
                parentSize.width / 2 - childSize.width / 2,
                parentSize.height / 2 - childSize.height / 2,
                childSize.width,
                childSize.height );
        }
    }
}
